<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가 

global $at_set;

// 옵션
$wos = apms_query($options);

// 효과
switch($wos['effect']) {
	case 'fade'		: $effect = ' slide at-fade'; break;
	case 'up'		: $effect = ' slide at-vertical'; break;
	case 'slide'	: $effect = ' slide'; break;
	case 'show'		: $effect = ''; break;
	default			: $effect = ' slide'; break;
}

// 효과시간
$interval = ($wos['interval']) ? $wos['interval'] : 5000;

// Random Ticker Id
$carousel_id = apms_id();

?>

<div id="<?php echo $carousel_id;?>" class="carousel<?php echo $effect;?> widget-title" data-ride="carousel" data-interval="<?php echo $interval;?>">
	 <!-- Indicators -->
	<ol class="carousel-indicators">
		<li data-target="#<?php echo $carousel_id;?>" data-slide-to="0" class="active"></li>
		<li data-target="#<?php echo $carousel_id;?>" data-slide-to="1"></li>
	</ol>

	<div class="carousel-inner">
		<div class="item active carousel-title-background carousel-title-background-1" style="background-image:url('<?php echo $at_set['title_background_1'];?>');">
			<div class="container">
				<div class="description fluid-center">
					<span class="title" style="text-transform:uppercase"><b>APMS Basic Thema</b></span>
					<span class="subtitle">Created for APMS & Maximum Responsiveness.</span>
					<span class="features">
						<i class="fa fa-html5"></i>
						<i class="fa fa-css3"></i>
						<i class="fa fa-twitter"></i>
					</span>
				</div>
			</div>
		</div> 
		<div class="item carousel-title-background carousel-title-background-2" style="background-image:url('<?php echo $at_set['title_background_2'];?>');">
			<div class="container">
				<div class="description">
					<span class="title" style="text-transform:uppercase"><b>APMS Basic Thema</b></span>
					<span class="subtitle">Create thema Based on Bootstrap3</span>
					<ul class="carousel-item-list">
						<li><i class="fa fa-check-square"></i> Support for G5/YC5 </li>
						<li><i class="fa fa-check-square"></i> Support for PC & Mobile</li>
						<li><i class="fa fa-check-square"></i> Support for IE8+, Chrome, Safari, Opera, Swing, etc</li>
						<li><i class="fa fa-check-square"></i> Maximum Responsiveness</li>
					</ul>
				</div>
				<div class="object">
					<?php thema_widget_video($at_set['video_url'], 717, 320); ?>
				</div>
			</div>
		</div>       
	</div>
	
	<!-- Controls -->
	<a class="left carousel-control" href="#<?php echo $carousel_id;?>" role="button" data-slide="prev">
		<span class="glyphicon glyphicon-chevron-left" aria-hidden="true"></span>
		<span class="sr-only">Previous</span>
	</a>
	<a class="right carousel-control" href="#<?php echo $carousel_id;?>" role="button" data-slide="next">
		<span class="glyphicon glyphicon-chevron-right" aria-hidden="true"></span>
		<span class="sr-only">Next</span>
	</a>
</div>

<div class="widget-banner bg-color">
	<div class="container">
		<div class="row">
			<div class="col-sm-8">
				<div class="ticker">
					<?php 
						// widget.post.newsticker.php 위젯 옵션
						// 기본옵션 : apms_board_rows() 옵션
						// 추가옵션 : carousel=효과(fade,up,slide,show),시간(ms 또는 false) / icon=제목아이콘(FA아이콘이름) / rank=랭킹표시(red,blue,green)
						thema_widget('post','widget.post.newsticker.php', 'carousel=slide,5000 rows=5 icon=fa-bell'); 
					?>
				</div>
			</div>
			<div class="col-sm-4">
				<a class="btn btn-trans pull-right" href="http://amina.co.kr/shop/item.php?it_id=beer">
					<i class="fa fa-beer"></i> Buy me a beer
				</a>
			</div>
		</div>
	</div>
</div>
